bool[][] hasTouched;

void MAP_Init()
{
	uint count = 0;

	for ( int i = 0; i < numEntities; i++ )
	{
		Entity@ ent = @G_GetEntity(i);
		if ( ent.get_classname() == "trigger_once" && ent.wait <= -1 )
		{
			Vec3 mins, maxs;
			ent.getSize(mins,maxs);
			Entity@ trigger_part = G_SpawnEntity("trigger_part");
			trigger_part.wait = count;
			trigger_part.setSize(mins,maxs);
			trigger_part.solid = SOLID_TRIGGER;
			trigger_part.target = ent.target;
			@trigger_part.touch = trigger_part_touch;
			trigger_part.linkEntity();
			ent.freeEntity();
			count++;
		}
	}

	hasTouched.resize(count);

	for ( uint i = 0; i < count; i++ )
	{
		hasTouched[i].resize(maxClients);
		for ( int j = 0; j < maxClients; j++ )
		{
			hasTouched[i][j] = false;
		}
	}
}

void trigger_part_touch(Entity @ent, Entity @other, const Vec3 planeNormal, int surfFlags)
{
	if ( @other.client == null )
		return;

	if ( hasTouched[uint(ent.wait)][other.client.playerNum] )
		return;

	ent.useTargets(other);
	hasTouched[uint(ent.wait)][other.client.playerNum] = true;
}

void target_resetpart_use(Entity @ent, Entity @other, Entity @activator)
{
	if ( @activator.client == null )
		return;

	for ( uint i = 0; i < hasTouched.size(); i++ )
	{
		hasTouched[i][activator.playerNum] = false;
	}
}

void target_resetpart(Entity@ ent)
{
	@ent.use = target_resetpart_use;
}
