// Created 03-05-2001
//  mod 04-20-2001

//*************************************************
// Entity Clip (clips everything)
// Created 9-28-2003
//************************************************
textures/island/entity_clip
{
	qer_editorimage textures/island/entityclip.tga
	qer_trans 0.40
	surfaceparm trans
	surfaceparm nodraw
	surfaceparm solid
}

//*************************************************
// Limestone
// Texture from Base_Wall - Shader 8-21-2003
//*************************************************
textures/island/limestone
{	
    qer_editorimage textures/island/concrete.tga
    surfaceparm nonsolid
	{
		map textures/island/concrete.tga
		blendFunc GL_ONE GL_ZERO
		depthWrite
		rgbGen identityLighting
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		depthFunc equal
	}
}

//*************************************************
// X Marks the Spot
// 
//*************************************************
textures/island/XMarks
{	
    qer_editorimage textures/island/Xmark.tga
    qer_trans 0.80
    surfaceparm trans
    surfaceparm nonsolid
    cull front
    nopicmip
    surfaceparm nolightmap

	{
		clampmap textures/island/Xmark.tga
            blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		alphaFunc GE128
		depthWrite rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	 }
}

//*************************************************
// Deep Ocean Fish
// 
//*************************************************
textures/island/Fish
{	
    qer_editorimage textures/sfx/fishy.tga
    qer_trans 0.99
    surfaceparm trans
    surfaceparm nonsolid
    cull front
    nopicmip
//    surfaceparm nolightmap

	{
		clampmap textures/sfx/fishy.tga
       	blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		depthWrite rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	 }
}

//*************************************************
// Palm Frond
// from Desert Temple level
//*************************************************
textures/island/palm_frond
{	
    qer_editorimage textures/island/desert/palmfrond.tga
    surfaceparm nonsolid
    cull none
    nopicmip
    deformVertexes wave 150 sin 0 1 0 .4
    surfaceparm nolightmap

	{
		map textures/island/desert/palmfrond.tga
		blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		depthWrite rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	 }
}

//*************************************************
// Palm Bark
// Texture from Desert Temple level - Shader 8-8-2003
//*************************************************
textures/island/palm_bark
{	
    qer_editorimage textures/island/desert/palmbark.tga
//    surfaceparm solid
	{
		map textures/island/desert/palmbark.tga
		blendFunc GL_ONE GL_ZERO
		depthWrite
		rgbGen identityLighting
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		depthFunc equal
	}
}
//*************************************************
// Ship Wood
// Texture from Desert Temple level - Shader 8-8-2003
//*************************************************
textures/island/shipwood
{	
    qer_editorimage textures/island/dunwich/ik_wood_trimv64d.tga
    surfaceparm nonsolid
	{
		map textures/island/dunwich/ik_wood_trimv64d.tga
		blendFunc GL_ONE GL_ZERO
		depthWrite
		rgbGen identityLighting
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		depthFunc equal
	}

}

//*************************************************
// bright flame
// Mod - non-solid Orig sfx/xflame2_1800
// from Quake3
//*************************************************

textures/island/flame_600
{
	surfaceparm nomarks
	surfaceparm nolightmap
      surfaceparm nonsolid
	cull none
	q3map_surfacelight 600
	qer_editorimage textures/sfx/flame1.tga
	

	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	


	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6	
	}

}

//*************************************************
// Noon Sky
// Mod - no cloud movement 12-15-2003
// from Post level 03-15-2001
//*************************************************

textures/island/noon_sky
{
	q3map_lightimage textures/common/white.tga
	q3map_lightsubdivide 2048
	q3map_globaltexture
	surfaceparm noimpact
	surfaceparm nolightmap


	q3map_sun	.5 .6 .8 125 45 65
	q3map_surfacelight 125

	qer_editorimage textures/island/post/gazeboTex099.tga

	skyparms - 512 -
	{
		map textures/island/post/gazeboTex099.tga

//		tcMod scale 3 2
//		tcMod scroll 0.025 0.025
		depthWrite
	}
	{
		map textures/island/post/gazeboTex100.tga

		blendFunc GL_ONE GL_ONE
//		tcMod scale 3 3
//		tcMod scroll 0.015 0.015
	}

}

//*************************************************
// Oceanfog
// Mod - no mod
// 09-28-2003
//*************************************************

textures/island/oceanfog
{
qer_editorimage textures/common/white.tga
surfaceparm	trans
surfaceparm	nonsolid
surfaceparm	fog
surfaceparm	nolightmap
qer_nocarve
fogparms ( 0.7 0.7 0.8 ) 2000
}

//*************************************************
// Ocean
// Mod - no mod
// 09-28-2003
//*************************************************

textures/island/ocean
{
qer_editorimage textures/island/slime7.tga
surfaceparm	trans
surfaceparm	nonsolid
surfaceparm	fog
surfaceparm	nolightmap
surfaceparm water
qer_nocarve
//deformVertexes wave 64 sin .5 .5 0 .5
fogparms ( 0.1 0.3 0.4 ) 1400
}


//*********************************************************
// Large clear ripple water. Created September 9
// Mod - Minimal engine load 12-15-2003       
//*********************************************************
	

textures/island/ocean_wave
	{
		qer_editorimage textures/island/ocean_5c.tga
		qer_trans .5
		q3map_globaltexture
		surfaceparm trans
		surfaceparm nonsolid
		surfaceparm water
		cull disable
		
		{ 
			map textures/island/ocean_5c.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 1.5 0 1.5 1 1 2
			tcmod scroll -.05 .001
		}
		{ 
			map textures/island/ocean_6c.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 0 1.5 1 1.5 2 1
			tcmod scroll .025 -.001
		}
		{ 
			map textures/island/ocean_3c.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .25 .5
			tcmod scroll .001 .025
		}	
		{
			map $lightmap
			blendFunc GL_dst_color GL_zero
			rgbgen identity		
		}
	}

//*************************************************
// Health Slime
// Mod - 
// 09-28-2003
//*************************************************

textures/island/altarslime_900
	{
	//	*************************************************		
	//	* SLIME Feb 11 1999 				*
	//	* IF YOU CHANGE THIS PLEASE COMMENT THE CHANGE	*
	//	*************************************************	

		// Added to g3map_global texture on May 11, 1999
		// substituted water for slime Sep 28, 2003
		qer_editorimage textures/liquids/slime7.tga
		q3map_lightimage textures/liquids/slime7.tga
		q3map_globaltexture
		qer_trans .5

		surfaceparm noimpact
		surfaceparm water
		surfaceparm nolightmap
		surfaceparm trans		

		q3map_surfacelight 1400
		tessSize 32
//		cull disable

		deformVertexes wave 100 sin 0 1 .5 .5

		{
			map textures/liquids/slime7c.tga
			tcMod turb .3 .2 1 .05
			tcMod scroll .01 .01
		}
	
		{
			map textures/liquids/slime7.tga
			blendfunc GL_ONE GL_ONE
			tcMod turb .2 .1 1 .05
			tcMod scale .5 .5
			tcMod scroll .01 .01
		}

		{
			map textures/liquids/bubbles.tga
			blendfunc GL_ZERO GL_SRC_COLOR
			tcMod turb .2 .1 .1 .2
			tcMod scale .05 .05
			tcMod scroll .001 .001
		}		

	}

// END
